<?PHP
/* ---------------------------------------------------------------
   %PROJECT:  WEBSYNC
   %FILENAME: main_0_db.inc
   %VERSION:  1.003

   %DESCRIPTION:
           This routine initializes environment for simple file
           upload from palm device.

   %HISTORY:
     2008-04-19 Artur Cielak  1.003
                Dodano inicjalizacj zmiennej $GLOBALS["APPVERSION"] przechowujcej
                przesan wersj aplikacji i zapisywan w pliku sesji
     2007-01-09 A.Cieslak
                Code revision. Added support for register_globals
                directive. Includes moved to subfolder
     2004-02-29 A.Cieslak
                Routine created

------------------------------------------------------------------ */

/* ------------------------------------
   Include user configuration
   ------------------------------------ */
include_once "wsutils.inc";
include_once "getuserconf.inc";


/* ------------------------------------
   Initialization of local parameters
   ------------------------------------ */
$uhome   = ""; //katalog domowy uytkownika
$ses     = ""; //identyfikator sesji
$sesfile = "";
$caver   = ""; // wersja aplikacji klienta

/* -----------------------------------
   Working Directory
   ----------------------------------- */
$taa = explode('/',$_SERVER["REQUEST_URI"]);
$taa[count($taa)-1] = "";
unset($taa[0]);
$GLOBALS["WORK_DIR"] = join('/',$taa);
applog($GLOBALS["WORK_DIR"]);

/* -----------------------------------

   ----------------------------------- */
if(!$GLOBALS["WEBSYNC_ERROR"]) {
  $GLOBALS["appver"]=parm("appver");
  if(!$GLOBALS["appver"]) {
    $caver=0;
  } else {
    $caver=cntver($GLOBALS["appver"]);
  }
  $GLOBALS["APPVERSION"]=$GLOBALS["appver"]; // 1.003
}

/* -----------------------------------
   USER ID check
   ----------------------------------- */
if($caver<cntver("1.7.0.0")) {
  if(!$GLOBALS["WEBSYNC_ERROR"]) {
    $GLOBALS["userid"]=parm("userid");
    if(!$GLOBALS["userid"]) {
      applog("Error: Nie podano nazwy uytkownika");
      echo 'ALERT Nie podano nazwy uytkownika';
      $GLOBALS["WEBSYNC_ERROR"] = -1;
    }
  }
} else {
  $GLOBALS["userid"]="";
}

/* -----------------------------------
   PDA ID check
   ----------------------------------- */
if(!$GLOBALS["WEBSYNC_ERROR"]) {
  $GLOBALS["pdaid"]=parm("pdaid");
  if(!$GLOBALS["pdaid"]) {
    applog("Error: Nie podano numeru seryjnego urzdzenia");
    echo 'ALERT Nie podano numeru seryjnego urzdzenia';
    $GLOBALS["WEBSYNC_ERROR"] = -2;
  }
}

/* -----------------------------------
   Check access rights
   ----------------------------------- */
if(!$GLOBALS["WEBSYNC_ERROR"]) {
  $retval = GetUserConf($GLOBALS["pdaid"],$GLOBALS["userid"],$GLOBALS["caver"]);
  if($retval) { // cos z tym userem nie tak
    applog("Error: Dostp dla uytkownika zablokowany");
    echo 'ALERT Brak autoryzacji';
    $GLOBALS["WEBSYNC_ERROR"] = -3;
  }
}


/* -----------------------------------
   Check home directory
   ----------------------------------- */
if(!$GLOBALS["WEBSYNC_ERROR"]) {
  if(!is_dir($GLOBALS["UHOME"])) {
    applog("Error: Brak katalogu domowego uytkownika lub dostp zabroniony");
    echo 'ALERT Brak katalogu domowego uytkownika lub dostp zabroniony';
    $GLOBALS["WEBSYNC_ERROR"] = -4;
  }
}

/* -----------------------------------
   Check for data existing
   ----------------------------------- */
if(!$GLOBALS["WEBSYNC_ERROR"]) {
  $GLOBALS["PHOME"]=sprintf("%s%s%s",$GLOBALS["UHOME"],$GLOBALS["DIRECTORY_SEPARATOR"],$GLOBALS["BACKUP_SUBDIR"]);
  if(!is_dir($GLOBALS["PHOME"])) {
    applog("Error: Brak katalogu z danymi lub dostp zabroniony");
    echo 'ALERT Brak katalogu z danymi lub dostp zabroniony';
    $GLOBALS["WEBSYNC_ERROR"] = -5;
  }
}

/* -----------------------------------
   Setup file name and session dir
   ----------------------------------- */
if(!$GLOBALS["WEBSYNC_ERROR"]) {
  $GLOBALS["DBFILE"]=sprintf("%s%s%s.pdb",$GLOBALS["PHOME"],$GLOBALS["DIRECTORY_SEPARATOR"],$GLOBALS["DBFNAME"]);
  $sesfile = sprintf("%s%s%s.ses",$GLOBALS["SESDIR"],$GLOBALS["DIRECTORY_SEPARATOR"],$GLOBALS["ses"]);
  if(file_exists($sesfile)) {
    applog("Error: Prba podczenia do istniejcej sesji nieudana");
    echo 'ALERT Prba podczenia do istniejcej sesji nieudana (sesid=' . $GLOBALS["ses"] .')';
    $GLOBALS["WEBSYNC_ERROR"] = -8;
  }
}
?>
