<?PHP
/* ------------------------------------------------------------------
   Plik doczany podczas potwierdzenia przesanych danych
   --

   Historia:
   2004-03-13: poprawniono bdne sprawdzanie czy w danej sesji byo
               ju wykonywane potwierdzenie.

   ------------------------------------------------------------------ */
include_once("php-pdb.inc");
include_once("websync.inc");
include_once("wsutils.inc");
include_once("writelog.inc");
include_once("mail.inc");
include_once("errmsg.inc");

$GLOBALS["ALLOW_EXEC"]=0;

$GLOBALS["ses"]=parm("ses");
if($GLOBALS["ses"]=="") {
  applog($APPMSG[1]); // no session
  echo $errmsg[1]; //brak sesji, ale to nie miejsce na komunikaty
  return;
}

$GLOBALS["cid"]=parm("cid");
if($GLOBALS["cid"]=="") {
  $GLOBALS["cid"]=0;
}

$blad=0;
$sesfile = sprintf("%s/%s.ses",$GLOBALS["SESDIR"],$GLOBALS["ses"]);

if(!file_exists($sesfile)) {
  writelog($sesfile,$ERRMSG[2],1); //brak pliku z sesj ale to nie miejsce na komunikaty
  applog(sprintf($appmgs[2],$sesfile));
  exit;
}

include($sesfile);

if(count($GLOBALS["CONF_FILENAME"])<=0)
  $blad=1;

$GLOBALS["nosesconfirmation"]=0;
for($fi=0;$fi<count($GLOBALS["CONF_FILENAME"]);$fi++) {
  if(isset($GLOBALS["CONF_FILENAME_VER"][$fi])) {
    if($GLOBALS["CAVER"]>=cntver($GLOBALS["CONF_FILENAME_VER"][$fi])) {
      if(isset($GLOBALS["CONF_FILENAME_VERMAX"][$fi])) {
        if($GLOBALS["CAVER"]<=cntver($GLOBALS["CONF_FILENAME_VERMAX"][$fi])) {
          $proc_file=1;
        } else {
          $proc_file=0;
        }
      } else {
        $proc_file=1;
      }
    } else {
      $proc_file=0;
    }
  } else {
    $proc_file=1;
  }

  if($proc_file) {
    if (isset($GLOBALS["CONF_DONE"][$GLOBALS["CONF_FILENAME"][$fi]])) {
      applog(sprintf($APPMSG[3],$GLOBALS["CONF_FILENAME"][$fi],$GLOBALS["CONF_DONE"][$GLOBALS["CONF_FILENAME"][$fi]]));
    }
    if(!isset($GLOBALS["CONF_DONE"][$GLOBALS["CONF_FILENAME"][$fi]]) || $GLOBALS["CONF_DONE"][$GLOBALS["CONF_FILENAME"][$fi]]!="OK") {
      if($blad==0) {
        $GLOBALS["CONF_DONE"][$GLOBALS["CONF_FILENAME"][$fi]]="INIT";
        $fp = @fopen($sesfile,"a+");
        if($fp) {
          fputs($fp,"<?PHP\n");
          fputs($fp,sprintf('$GLOBALS["CONF_DONE"]["%s"]="INIT";',$GLOBALS["CONF_FILENAME"][$fi]));
          fputs($fp,"\n?>");
          fclose($fp);
        } else {
          applog($APPMSG[4]);
          echo $ERRMSG[3];
          exit;
        }
        $GLOBALS["nosesconfirmation"]=1;
        $blad=1;
        $fexists[$fi] = 0;
        $old_pdb = 0;
        $pdbname=$GLOBALS["PDB_DATABASE"][$GLOBALS["APPDATAVIDX"]][$GLOBALS["CONF_FILENAME"][$fi]]["NAME"];
        $GLOBALS["STOREDPDB"] = sprintf('%s/%s/%s.pdb',$GLOBALS["SESDIR"],$GLOBALS["ses"],$pdbname);
        if(!file_exists($GLOBALS["STOREDPDB"])) {
          /* Zmiana: dodano warunek if($fi==0) - to znaczy e wymagany jest tylko
             pierwszy plik - nastpne mog nie by przysane - to jest potencjalna sabo
             rozwizania - docelowo powinny by wprowadzone parametry w kliencie ktre
             bd przesyane na pocztku z informacja jakie bazy bda przesyana */
          if($fi==0) {
            writelog($sesfile,"NO PDB FILE",1);
            applog(sprintf($APPMSG[5],$GLOBALS["STOREDPDB"]));
            exit;
          } else {
            applog(sprintf($APPMSG[6],$GLOBALS["STOREDPDB"]));
            $blad=0;
          }
        } else {
          $fexists[$fi] = 1;
        }

        if($fexists[$fi]==1) {
          $fd = @fopen($GLOBALS["STOREDPDB"],"r");
          if(!$fd) {
            writelog($sesfile,$ERRMSG[4],1);
            applog(sprintf($APPMSG[7],$GLOBALS["STOREDPDB"]));
            exit;
          }

          $GLOBALS["spdb"]=new PalmDB($GLOBALS["PDB_DATABASE"][$GLOBALS["APPDATAVIDX"]][$GLOBALS["CONF_FILENAME"][$fi]]["TYPE"]);
          $GLOBALS["spdb"]->ReadFile($fd);
          fclose($fd);

          $GLOBALS["pdbfname"] = basename($GLOBALS["STOREDPDB"]);

          $GLOBALS["npdb"]=new PalmDB($GLOBALS["PDB_DATABASE"][$GLOBALS["APPDATAVIDX"]][$GLOBALS["CONF_FILENAME"][$fi]]["TYPE"]);

          if(file_exists(sprintf("%s/%s",$GLOBALS["PHOME"],$GLOBALS["pdbfname"]))) {
            $old_pdb = 1;
            if($GLOBALS["OVERWRITE_EXISTING"]==0) {
              $fd = @fopen(sprintf("%s/%s",$GLOBALS["PHOME"],$GLOBALS["pdbfname"]),"r");
              if(!$fd) {
                writelog($sesfile,$ERRMSG[5],1);
                applog(sprintf($APPMSG[8],$GLOBALS["PHOME"],$GLOBALS["pdbfname"]));
                exit;
              }
              $GLOBALS["npdb"]->ReadFile($fd);
              fclose($fd);
            }
          }

          reset($GLOBALS["spdb"]->Records);
          if($GLOBALS["spdb"]->GetRecordCount()) {
            do {
              $GLOBALS["npdb"]->SetRecordRaw(key($GLOBALS["spdb"]->Records),current($GLOBALS["spdb"]->Records),PDB_RECORD_ATTRIB_DIRTY);
            } while(next($GLOBALS["spdb"]->Records));
          }
          $fd = @fopen(sprintf("%s/%s.new",$GLOBALS["PHOME"],$GLOBALS["pdbfname"]),"wb");
          if($fd) {
            $GLOBALS["npdb"]->Name      = $pdbname;
            $GLOBALS["npdb"]->Version   = intval($GLOBALS["PDB_DATABASE"][$GLOBALS["APPDATAVIDX"]][$GLOBALS["CONF_FILENAME"][$fi]]["VERSION"],16);
            $GLOBALS["npdb"]->CreatorID = $GLOBALS["PDB_DATABASE"][$GLOBALS["APPDATAVIDX"]][$GLOBALS["CONF_FILENAME"][$fi]]["CREATOR"];
            $GLOBALS["npdb"]->WriteToFile($fd);
            fclose($fd);
            if($old_pdb == 1) @rename(sprintf("%s/%s",$GLOBALS["PHOME"],$GLOBALS["pdbfname"]),sprintf("%s/%s.old",$GLOBALS["PHOME"],$GLOBALS["pdbfname"]));
            @rename(sprintf("%s/%s.new",$GLOBALS["PHOME"],$GLOBALS["pdbfname"]),sprintf("%s/%s",$GLOBALS["PHOME"],$GLOBALS["pdbfname"]));
            chmod(sprintf("%s/%s",$GLOBALS["PHOME"],$GLOBALS["pdbfname"]),0666);
            $blad=0;
            $GLOBALS["CONF_DONE"][$GLOBALS["CONF_FILENAME"][$fi]]="OK";
            $fp = @fopen($sesfile,"a+");
            if($fp) {
              fputs($fp,"<?PHP\n");
              fputs($fp,sprintf('$GLOBALS["CONF_DONE"]["%s"]="OK";',$GLOBALS["CONF_FILENAME"][$fi]));
              fputs($fp,"\n?>");
              fclose($fp);
            } else {
              applog($APPMSG[4]);
              echo $ERRMSG[3];
              exit;
            }
          } else {
            writelog($sesfile,$ERRMSG[6],1);
            applog(sprintf($APPMSG[9],$GLOBALS["PHOME"],$GLOBALS["pdbfname"]));
            exit;
          }
        }
      }
    } else {
      applog(sprintf($APPMSG[10],$GLOBALS["CONF_FILENAME"][$fi]));
      echo $ERRMSG[0];
    }
  }
}

$GLOBALS["ALLOW_EXEC"]=0;
if($GLOBALS["nosesconfirmation"]==1) {
  $mailer = new sendmail;
  $mailer->init();
  if($blad) {
    $mailer->MailTitle($MAILMSG[1]);
  } else {
    $mailer->MailTitle($MAILMSG[2]);
  }
  $mailer->AddMessage($MAILMSG[3] . date("Y-m-d"));
  $mailer->AddMessage($MAILMSG[4] . date("H:i"));
  $mailer->AddMessage($MAILMSG[10]);
  $mailer->AddMessage($MAILMSG[5] . $GLOBALS["ses"]);
  $mailer->AddMessage($MAILMSG[6] . $GLOBALS["UNAME"]);
  $mailer->AddMessage($MAILMSG[7] . $GLOBALS["PDAID"]);
  $mailer->AddMessage($MAILMSG[10]);
  for($fi=0;$fi<count($GLOBALS["CONF_FILENAME"]);$fi++) {
    if(isset($GLOBALS["CONF_FILENAME"][$fi]["VER"])) {
      if($GLOBALS["CAVER"]>=cntver($GLOBALS["CONF_FILENAME"][$fi]["VER"])) {
        if(isset($GLOBALS["CONF_FILENAME"][$fi]["VERMAX"])) {
          if($GLOBALS["CAVER"]<=cntver($GLOBALS["CONF_FILENAME"][$fi]["VERMAX"])) {
            $proc_file=1;
          } else {
            $proc_file=0;
          }
        } else {
          $proc_file=1;
        }
      } else {
        $proc_file=0;
      }
    } else {
      $proc_file=1;
    }
    if($proc_file) {
      if(isset($fexists[$fi]) && $fexists[$fi]==1)
        $mailer->AddMessage($MAILMSG[8] . sprintf("%s/%s",$GLOBALS["PHOME"],$GLOBALS["PDB_DATABASE"][$GLOBALS["APPDATAVIDX"]][$GLOBALS["CONF_FILENAME"][$fi]]["NAME"]));
      else
        $mailer->AddMessage($MAILMSG[9] . sprintf("%s/%s",$GLOBALS["PHOME"],$GLOBALS["PDB_DATABASE"][$GLOBALS["APPDATAVIDX"]][$GLOBALS["CONF_FILENAME"][$fi]]["NAME"]));
    }
  }
  $mailer->Mail();

  if($blad==0) {
    $GLOBALS["ALLOW_EXEC"]=1;
    writelog($sesfile,$ERRMSG[0],1);
  } else {
    writelog($sesfile,$ERRMSG[7],1);
  }
} else {
  if($blad==0) {
    writelog($sesfile,$ERRMSG[0],1);
  } else {
    writelog($sesfile,$ERRMSG[7],1);
  }
}
?>
